#!/usr/bin/env python
import RPi.GPIO as GPIO
from mfrc522 import SimpleMFRC522
import subprocess
import json
import time
import threading
import queue
import requests
import env


def check_internet_connection():
    try:
        subprocess.check_output(["ping", "-c", "1", "8.8.8.8"])
        return True
    except subprocess.CalledProcessError:
        return False


def read_tag():
    try:
        while True:
            print('You can scan tag')
            rfid_id, text = reader.read()
            rfid_id = str(rfid_id)
            if rfid_id in saved_cards_data:
                print('ok')
                queue_attendance.put(rfid_id)
                GPIO.output(env.green_led, True)
                time.sleep(1)
                GPIO.output(env.green_led, False)
            else:
                print('nie')
                GPIO.output(env.red_led, True)
                time.sleep(1)
                GPIO.output(env.red_led, False)
            time.sleep(2)
    finally:
        GPIO.cleanup()


def process_queue():
    while True:
        if queue_attendance.empty() or not check_internet_connection():
            time.sleep(2)
        else:
            rfid_id = queue_attendance.get()
            requests.get(env.domain_url+'/system/scan-card/attendance', params={
                'rfid_id': rfid_id,
                'type': 'DEPARTURE',
                'api_key': env.api_key,
            })


def save_cards_data():
    global saved_cards_data
    while True:
        response = requests.get(env.domain_url+'/system/scan-card/send_data', params={
            'api_key': env.api_key,
        })
        if response.status_code == 200:
            response.content.decode()
            current_card_data = set(json.loads(response.content.decode()))
            saved_cards_data = current_card_data
        time.sleep(3600)


GPIO.setmode(GPIO.BCM)
GPIO.setup(env.green_led, GPIO.OUT)
GPIO.setup(env.red_led, GPIO.OUT)
queue_attendance = queue.Queue()
saved_cards_data = set()
reader = SimpleMFRC522()

t_read_tag = threading.Thread(target=read_tag, name='t_read_tag')
t_process_queue = threading.Thread(target=process_queue, name='t_process_queue')
t_save_cards_data = threading.Thread(target=save_cards_data, name='t_save_cards_data')

t_read_tag.start()
t_process_queue.start()
t_save_cards_data.start()

t_read_tag.join()
t_process_queue.join()
t_save_cards_data.join()
